<?php
/* --------------------------------------------------------------
   PayPalHubProductInfoContentView.inc.php 2020-05-08
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class PayPalHubProductInfoContentView extends PayPalHubProductInfoContentView_parent
{
    public function build_html($p_content_data_array = false, $p_template_file = false)
    {
        $html = parent::build_html($p_content_data_array, $p_template_file);
        if(strtolower((string)@constant('MODULE_PAYMENT_GAMBIO_HUB_STATUS')) !== 'true') {
            return $html;
        }
        
        /** @var \HubPayPalConfiguration $hubPayPalConfiguration */
        $hubPayPalConfiguration = MainFactory::create('HubPayPalConfiguration');
        if ($hubPayPalConfiguration->isECSProduct()) {
            $productECSScript = file_get_contents(dirname(dirname(__DIR__)) . '/Javascript/PayPalProductECS.js');
            if ($productECSScript !== false) {
                $buttonConfigurationJson = json_encode($hubPayPalConfiguration->getECSButtonConfiguration());
                $productECSScript        = str_replace(
                    'buttonConfiguration = {}',
                    'buttonConfiguration = ' . $buttonConfigurationJson,
                    $productECSScript
                );
                $text = MainFactory::create('LanguageTextManager', 'gambio_hub_paypal');
                $phrasesJson = json_encode(
                    [
                        'separatorLabel' => $text->get_text('ecs_button_intro'),
                    ]
                );
                $productECSScript = str_replace(
                    'phrases = {}',
                    'phrases = ' . $phrasesJson,
                    $productECSScript
                );
                $html                    .= '<script>' . $productECSScript . '</script>';
            }
        }
        
        return $html;
    }
    
    
    protected function _assignPayPalInstallments()
    {
        $hubPayPalConfiguration = MainFactory::create('HubPayPalConfiguration');
        $moduleInstalled = strtolower((string)@constant('MODULE_PAYMENT_PAYPAL3_INSTALLMENTS_STATUS')) === 'true';
        $moduleInstalled = $moduleInstalled || $hubPayPalConfiguration->isInstallmentsActive();
        if ($moduleInstalled !== true) {
            return;
        }
        $output              = '';
        $paypalConfiguration = MainFactory::create('PayPalConfigurationStorage');
        $showSpecific        = (bool)$paypalConfiguration->get('show_installments_presentment_specific_product');
        $hasAttributes       = trim($this->content_array['MODULE_product_options']) !== '';
        $showComputed        = $hasAttributes === false &&
                               $this->hasProperties === false &&
                               (bool)$paypalConfiguration->get('show_installments_presentment_specific_computed');
        $productPrice        = $this->productPriceArray['plain'];
        $paypalInstallments  = MainFactory::create('PayPalInstallments');
        if ($showSpecific &&
            $productPrice >= $paypalInstallments->getMinimumAmount()['amount'] &&
            $productPrice <= $paypalInstallments->getMaximumAmount()['amount'])
        {
            if ($showComputed === true) {
                try {
                    $response = $paypalInstallments->getInstallmentInfo($productPrice, $_SESSION['currency'], 'DE');
                    if (!empty($response->financing_options[0]->qualifying_financing_options)) {
                        $representativeOption                             = $paypalInstallments->getRepresentativeOption(
                            $response->financing_options[0]->qualifying_financing_options
                        );
                        $specificContentView                              = MainFactory::create(
                            'PayPalInstallmentSpecificUpstreamPresentmentContentView'
                        );
                        $specificContentView->qualifyingOptions           = $response->financing_options[0]->qualifying_financing_options;
                        $specificContentView->nonQualifyingOptions        = $response->financing_options[0]->non_qualifying_financing_options;
                        $lender = '';
                        if ($hubPayPalConfiguration->isInstallmentsActive()) {
                            $lender = (string)gm_get_conf('GAMBIO_HUB_REMOTE_CONFIG_PAYPALHUB_IUP_LENDER');
                        }
                        if ($lender === null || $hubPayPalConfiguration->isInstallmentsActive() !== true) {
                            $lender = implode(
                                ', ',
                                [
                                    COMPANY_NAME,
                                    TRADER_STREET . ' ' . TRADER_STREET_NUMBER,
                                    TRADER_ZIPCODE . ' ' . TRADER_LOCATION,
                                ]
                            );
                        }
                        
                        $specificContentView->lender                      = $lender;
                        $specificContentView->currency                    = $_SESSION['currency'];
                        $specificContentView->cashPurchasePrice           = $productPrice;
                        $specificContentView->numberOfInstallments        = $representativeOption->credit_financing->term;
                        $specificContentView->borrowingRate               = $representativeOption->credit_financing->nominal_rate;
                        $specificContentView->annualPercentageRate        = $representativeOption->credit_financing->apr;
                        $specificContentView->installmentAmount           = $representativeOption->monthly_payment->value;
                        $specificContentView->totalAmount                 = $representativeOption->total_cost->value;
                        $specificContentView->representativeFinancingCode = $representativeOption->credit_financing->financing_code;
                        $output                                           = $specificContentView->get_html();
                    }
                } catch (Exception $e) {
                    $output = sprintf("<!-- PPI Exception -->\n");
                }
            } else {
                if ($this->hasProperties || $hasAttributes) {
                    $amount = 'dynamic';
                } else {
                    $amount = $productPrice;
                }
                $contentView = MainFactory::create('ContentView');
                $contentView->set_content_template('module/paypalinstallmentspecificstatic.html');
                $contentView->set_flat_assigns(true);
                $contentView->set_caching_enabled(false);
                $contentView->set_content_data('amount', $amount);
                $output = $contentView->get_html();
            }
        } else {
            $contentView = MainFactory::create('ContentView');
            $contentView->set_content_template('module/paypalinstallmentspecificoutofbounds.html');
            $contentView->set_flat_assigns(true);
            $contentView->set_caching_enabled(false);
            $output = $contentView->get_html();
        }
        $this->set_content_data('PayPalInstallments', $output);
    }
}
